Add-Type -Language CSharp -TypeDefinition @"
using System;
using System.Runtime.InteropServices;

public class PrinterConfig {
    [DllImport("winspool.drv", SetLastError = true)]
    public static extern bool OpenPrinter(string pPrinterName, out IntPtr hPrinter, IntPtr pDefault);

    [DllImport("winspool.drv", SetLastError = true)]
    public static extern bool ClosePrinter(IntPtr hPrinter);

    [DllImport("winspool.drv", SetLastError = true)]
    public static extern int DocumentProperties(IntPtr hwnd, IntPtr hPrinter, string pDeviceName,
        IntPtr pDevModeOutput, IntPtr pDevModeInput, int fMode);

    public const int DM_COLOR = 0x800;
    public const short DMCOLOR_MONOCHROME = 1;
    public const short DMCOLOR_COLOR = 2;

    public const int DM_IN_BUFFER = 0x8;
    public const int DM_OUT_BUFFER = 0x2;

    public static void SetPrinterToMonochrome(string printerName) {
        IntPtr hPrinter;
        if (!OpenPrinter(printerName, out hPrinter, IntPtr.Zero)) {
            throw new Exception("Drucker konnte nicht geöffnet werden.");
        }

        // Erste Abfrage: Wie groß ist der DEVMODE?
        int sizeNeeded = DocumentProperties(IntPtr.Zero, hPrinter, printerName, IntPtr.Zero, IntPtr.Zero, 0);
        if (sizeNeeded <= 0) {
            ClosePrinter(hPrinter);
            throw new Exception("Konnte DEVMODE-Größe nicht ermitteln.");
        }

        // Speicher allokieren für Input & Output DEVMODE
        IntPtr pDevModeInput = Marshal.AllocHGlobal(sizeNeeded);
        IntPtr pDevModeOutput = Marshal.AllocHGlobal(sizeNeeded);

        // DEVMODE vom Drucker holen
        int getDevModeResult = DocumentProperties(IntPtr.Zero, hPrinter, printerName, pDevModeInput, IntPtr.Zero, 0);
        if (getDevModeResult < 0) {
            ClosePrinter(hPrinter);
            Marshal.FreeHGlobal(pDevModeInput);
            Marshal.FreeHGlobal(pDevModeOutput);
            throw new Exception("Konnte DEVMODE nicht vom Drucker abrufen.");
        }

        // Lesen und bearbeiten
        int offset = 104; // typischer Offset von dmColor innerhalb DEVMODE (abhängig vom Treiber!)
        byte[] devmodeData = new byte[sizeNeeded];
        Marshal.Copy(pDevModeInput, devmodeData, 0, sizeNeeded);

        // Setze das dmColor-Feld auf MONOCHROME (1)
        devmodeData[offset + 0] = (byte)(DMCOLOR_MONOCHROME & 0xFF);       // Low Byte
        devmodeData[offset + 1] = (byte)((DMCOLOR_MONOCHROME >> 8) & 0xFF); // High Byte

        // Setze dmFields (aktiviert die Einstellung) — Bit 11 (0x800)
        devmodeData[76] |= 0x00;  // low byte bleibt gleich
        devmodeData[77] |= 0x08;  // high byte |= 0x08 → 0x800 aktiviert DM_COLOR

        Marshal.Copy(devmodeData, 0, pDevModeInput, sizeNeeded);

        // Setzen des neuen DEVMODEs
        int setResult = DocumentProperties(IntPtr.Zero, hPrinter, printerName, pDevModeOutput, pDevModeInput, DM_IN_BUFFER | DM_OUT_BUFFER);
        if (setResult < 0) {
            throw new Exception("Setzen des bearbeiteten DEVMODE fehlgeschlagen.");
        }

        ClosePrinter(hPrinter);
        Marshal.FreeHGlobal(pDevModeInput);
        Marshal.FreeHGlobal(pDevModeOutput);
    }
}
"@

# 🎯 Name deines Druckers
[PrinterConfig]::SetPrinterToMonochrome("2508ci KX")
